/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.contentassist.XMLContentAssistProcessor;
import com.aptana.xml.core.model.ElementElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.events.VerifyEvent;

public class XMLTagProposal
extends CommonCompletionProposal {
    private Integer[] _positions;

    protected XMLTagProposal(String replacementString, int replacementOffset, int replacementLength, ElementElement element, Integer ... positions) {
        super(replacementString, replacementOffset, replacementLength, positions[0].intValue(), XMLContentAssistProcessor.ELEMENT_ICON, element.getName(), null, element.getDescription());
        this.setFileLocation("XML Core");
        this._positions = positions;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        if (!ArrayUtil.isEmpty((Object[])this._positions)) {
            IDocument document = viewer.getDocument();
            boolean validPrefix = this.isValidPrefix(this.getPrefix(document, offset), this.getDisplayString());
            int shift = validPrefix ? offset - this._replacementOffset : 0;
            try {
                LinkedModeModel.closeAllModels((IDocument)document);
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                Integer[] integerArray = this._positions;
                int n = this._positions.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = integerArray[n2];
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, offset - shift + pos, 0, i++));
                    model.addGroup(group);
                    ++n2;
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setExitPolicy(new LinkedModeUI.IExitPolicy(){

                    public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
                        if (event.character == '\n' || event.character == '\r') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                        return null;
                    }
                });
                ui.setCyclingMode(LinkedModeUI.CYCLE_ALWAYS);
                ui.setExitPosition(viewer, offset - shift + this._positions[this._positions.length - 1], 0, Integer.MAX_VALUE);
                ui.enter();
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

